import React from 'react';
import Modal from '@material-ui/core/Modal';
import StyledButton from 'components/StyledButton';
import useStyles from './styles';

type Props = {
    open: boolean,
    strings: object,
    btnCallback: () => {}
};

function FWUpdateInterrupted({ open, strings, btnCallback }: Props) {
    const classes = useStyles();

    return (
        <Modal open={open}>
            <div className={classes.modalContainer}>
                <div className={classes.modalTitle}>
                    {strings.welcome_modal_device_fw_interrupted_title}
                </div>
                <div className={classes.modalDescription}>
                    {strings.welcome_modal_device_fw_interrupted_description}
                </div>
                <div className={classes.modalButtonContainer}>
                    <StyledButton
                        variant="contained"
                        btnSize="small"
                        onClick={btnCallback}
                    >
                        {strings.button_ok}
                    </StyledButton>
                </div>
            </div>
        </Modal>
    );
}

export default FWUpdateInterrupted;
